ORG 400000h
BITS 32

;
; Summary: stage4_load.asm
; *The bootstrap user module*
;
; Although replacing this module with another can allow the
; user to run an effectively different operating system, this
; is currently the default.
;
; Checks and loads all modules present in the ramdisk and
; starts each of them
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational purposes
;

; EAX = ramdisk address in linear memory

CPU 486

%include "inc_syscall.asm"
%include "inc_ia.asm"
%include "inc_elf.asm"

start:              MOV ESP, stackend
                    MOV [iPhysRamdisk], EAX

                    Call allocramdisk
                    Call initcombuffer
                    Call loadunittable
lbl:
                    ;Call lpcAppBase
                    ;JMP CreateTask

.lbl:               kernel Yield
                    Call checkmessageport
                    jmp .lbl

times 0x40-($-$$) nop
                    DD ELF_Copysection
                    DD checkmessageport.reply

allocramdisk:       STC
                    SBB ESI, ESI
                    MOV EDI, lpcRamdiskBase
                    kernel AllocatePageTable
                    STC
                    SBB ESI, ESI
                    MOV EDI, lpcAppBase
                    kernel AllocatePageTable

                    MOV EDI, [iPhysRamdisk]
                    STC
                    SBB ESI, ESI
                    kernel ManageMemoryL1

                    XOR EBX, EBX
                    MOV BL, 1
                    MOV ESI, [iPhysRamdisk]
                    MOV EAX, ESI
                    MOV EDI, lpcRamdiskBase
                    AND EAX, PAGE_PARAMMASK
                    ADD EAX, lpcRamdiskBase
                    MOV [lpRamdisk], EAX
                    kernel BlockAllocPhys
                    ;kernel MemMap

                    MOV EDI, [lpRamdisk]
                    XOR ECX, ECX

.loop:              MOV EAX, [EDI]
                    OR EAX, EAX
                    JZ .done

                    CMP dword [EDI+RD_NAME], 'LOAD'
                    JNE .noloadtab
                    CMP dword [EDI+RD_NAME+4], 'LIST'
                    JNE .noloadtab
                    MOV EAX, [EDI+RD_OFFSET]
                    ADD EAX, lpcRamdiskBase
                    MOV [lpLoadTab], EAX
.noloadtab:

                    MOV EDX, [EDI+RD_OFFSET]
                    MOV EBX, [EDI+RD_SIZE]
                    ADD EDX, EBX
                    CMP EDX, ECX
                    JNG .notbigger
                    MOV ECX, EDX
.notbigger:         ADD EDI, RD_ENTRYSIZE
                    JMP .loop

.done:              SHR ECX, 12
                    ADD ECX, 1
                    MOV EBX, ECX
                    MOV ESI, [iPhysRamdisk]
                    MOV EDI, lpcRamdiskBase+PAGE_SIZE
                    ADD ESI, PAGE_SIZE
                    kernel BlockAllocPhys
                    ;kernel MemMap

                    RET



                    ; Function: initcombuffer

initcombuffer:      STC
                    SBB ESI, ESI
                    MOV EDI, lpcCommBase
                    kernel AllocatePageTable

                    MOV EDI, lpcCommBase
                    MOV EBX, 1
                    kernel BlockAlloc

                    MOV EDI, lpcCommBase
                    MOV EDX, EDI
                    ADD EDI, 8
                    MOV [EDX], EDI
                    MOV [EDX+4], EDI

                    RET

                    ; Function: loadunittable
                    ;
loadunittable:      MOV ECX, lpcAppBase
                    MOV [lpCurrentBase], ECX

                    MOV ECX, [lpRamdisk]
.loop1:             MOV EAX, [ECX+RD_NAME]
                    MOV EBX, [ECX+RD_OFFSET]
                    MOV ESI, [lpRamdisk]
                    MOV EDI, [ECX+RD_SIZE]
                    ADD EBX, ESI
                    OR EAX, EAX
                    JZ .done
                    CMP EAX, 'STAG'
                    JE .skip

.stop:
                    CMP dword [lpLoadTab], 0
                    JE .noloadcheck
                    MOV EDX, [lpLoadTab]
.findloop:          MOV EAX, [EDX]
                    OR EAX, EAX
                    JZ .skip
                    MOV EAX, [ECX+RD_NAME]
                    CMP [EDX], EAX
                    JNE .checknext
                    MOV EAX, [ECX+RD_NAME + 4]
                    CMP [EDX+4], EAX
                    JNE .checknext
                    JMP .noloadcheck
.checknext:         ADD EDX, 8
                    JMP .findloop

.noloadcheck:
                    MOV EAX, EDI
                    PUSH ECX
                    CALL ELF_Start
                    POP ECX
.skip:              ADD ECX, RD_ENTRYSIZE
                    JMP .loop1
.done:              RET





checkmessageport:   PUSH EBP

                    MOV EAX, [lpcCommBase + 4]
                    AND EAX, 0x7FF
                    ADD EAX, lpcCommBase + 0x800
                    CMP dword [EAX], 0x00010002
                    JE .readmessage
                    POP EBP
                    RET

.readmessage:

                    MOV dword [EAX], 0

                    ADD EAX, 4
                    AND EAX, 0x7ff
                    ADD EAX, lpcCommBase + 0x800
                    MOV EBP, [EAX]
                    MOV dword [EAX], 0

                    ADD EAX, 4
                    AND EAX, 0x7ff
                    ADD EAX, lpcCommBase + 0x800
                    MOV EDI, [EAX]
                    ADD EDI, 15
                    AND EDI, 0xfffffffc
                    MOV dword [EAX], 0

                    ADD EAX, 4
                    AND EAX, 0x7ff
                    ADD EAX, lpcCommBase + 0x800
                    MOV ESI, [EAX]
                    MOV dword [EAX], 0

                    ADD EAX, 4
                    AND EAX, 0x7ff
                    ADD EAX, lpcCommBase + 0x800
                    MOV EBX, [EAX]
                    MOV dword [EAX], 0
                    ADD EAX, 4
                    AND EAX, 0x7ff
                    ADD EAX, lpcCommBase + 0x800
                    MOV ECX, [EAX]
                    MOV dword [EAX], 0
                    LOCK ADD [lpcCommBase+4], EDI

                    MOV EAX, [lpRamdisk]
.loop:              CMP dword [EAX], 0
                    JE .done
                    CMP [EAX+RD_NAME], EBX
                    JNE .next
                    CMP [EAX+RD_NAME+4], ECX
                    JNE .next

                    MOV EBX, [EAX+RD_OFFSET]
                    MOV EAX, [EAX+RD_SIZE]
                    ADD EBX, [lpRamdisk]

                    MOV EDI, [lpCurrentBase]
                    MOV [lpLastBase], EDI

                    ;ADD byte [0x0E400A], 1

                    PUSH ESI
                    Call ELF_Load
                    POP ESI

                    ;ADD byte [0x0E400B], 1

                    OR ESI, ESI
                    JZ .done
                    PUSH EBX

                    ;ADD byte [0x0E4001], 1

                    ; create new address space
                    STC
                    SBB ESI, ESI
                    MOV EDI, [lpCurrentBase]
                    kernel CreateAddressSpace

                    ;ADD byte [0x0E4002], 1

                    ; map required page table
                    MOV EDI, [lpCurrentBase]
                    MOV EBX, EDI
                    STC
                    SBB ESI, ESI
                    kernel AllocatePageTableRemote

                    ;ADD byte [0x0E4003], 1

                    ; copy pages
                    MOV EDI, [lpCurrentBase]
                    MOV EBX, EDI
                    MOV EAX, [lpLastBase]
.transferloop:      PUSH EAX
                    PUSH EBX
                    PUSH EDI

                    MOV EDI, EAX
                    MOV ESI, EAX
                    kernel TransferPage

                    POP EDI
                    POP EBX
                    POP EAX
                    ADD EAX, PAGE_SIZE
                    CMP EAX, EDI
                    JB .transferloop
                    ; done

                    POP EBX
                    ; EBX = Entry point
                    ; [lpCurrentBase] = PD
                    ; EBP = Sender

.reply:
                    MOV EAX, 20
                    LOCK XADD [lpcCommBase], EAX
                    AND EAX, 0x7FF
                    ADD EAX, lpcCommBase + 0x800


                    MOV EDX, [lpCurrentBase]
                    MOV       [EAX+16], EDX
                    MOV       [EAX+12], EBX
                    MOV dword [EAX+ 8], 8
                    MOV dword [EAX+ 4], 0x00010002
                    MOV       [EAX+ 0], EBP

                    ADD dword [lpCurrentBase], PAGE_SIZE
                    POP EBP
                    RET

.next:              ADD EAX, 16
                    JMP .loop

.done:              XOR EDX, EDX
                    XOR EBX, EBX
                    JMP .reply

                    RET



                    ;
                    ; Function: ELF_Start
                    ; Loads an elf file and start it
                    ;
                    ; in:
                    ;     - EBX = pointer to file in memory
                    ;     - EAX = length of file
                    ;
                    ; out:
                    ;     none
                    ;
                    ; destroyed:
                    ;     unknown
                    ;
ELF_Start:          Call ELF_Load
                    JNZ .fail
                    MOV EDI, [lpCurrentBase]
                    MOV EBX, [lpCurrentAppStart]
                    
                    MOV EAX, [lpCurrentHeap]
                    MOV EDX, [lpMessageStruct]
                    MOV [EDX], EAX
                    MOV dword [EDX+4], lpcCommBase
                    MOV dword [EDX+8], 0

                    STC
                    SBB ESI, ESI
                    kernel CreateThread

                    ADD dword [lpCurrentHeap], 0x01000000
                    ADD dword [lpMessageStruct], 16

                    ; schedule and hope it comes back
                    kernel Yield

                    ADD dword [lpCurrentBase], PAGE_SIZE

.fail:
                    RET


                    ;
                    ; Function: ELF_Load
                    ; Parses an elf file in memory
                    ;
                    ; in:
                    ;     - EBX = pointer to file in memory
                    ;     - EAX = length of file
                    ;
                    ; out:
                    ;     - EBX = address of entry point
                    ;
                    ; destroyed:
                    ;     unknown (all but ESP)
                    ;

ELF_Load:           MOV EDX, [EBX]
                    CMP EDX, 0x464c457f
                    JE .check1
                    RET
.check1:            CMP byte [EBX+EI_CLASS], ELFCLASS32
                    JE .check2
                    RET
.check2:            CMP byte [EBX+EI_DATA], ELFDATA2LSB
                    JE .check3
                    RET
.check3:            CMP byte [EBX+EI_VERSION], EV_CURRENT
                    JE .check4
                    RET
.check4:            CMP word [EBX+E_TYPE], ET_EXEC
                    JE .check5
                    RET
.check5:            CMP word [EBX+E_MACHINE], EM_386
                    JE .check6
                    RET
.check6:            CMP dword [EBX+E_VERSION], EV_CURRENT
                    JE .check7
                    RET
.check7:            MOV [iFilesize], EAX
                    ; Clear section storage
                    MOV EDI, lpSectionArray
                    MOV ECX, 64
                    XOR EAX, EAX
                    REP STOSD
                    
                    MOV EAX, [EBX+E_ENTRY]
                    MOV [lpStoredAppStart], EAX
                    MOV EDI, [lpCurrentBase]
                    MOV [lpCurrentAppStart], EDI
                    MOV EDX, [EBX+E_SHOFF]
                    ADD EDX, EBX
                    MOV [lpFileOffset], EBX
                    MOV [lpSectionTable], EDX
                    XOR EAX, EAX
                    XOR ECX, ECX
                    MOV AX, [EBX+E_SHENTSIZE]
                    MOV CX, [EBX+E_SHNUM]
                    MOV [iSectionLength], EAX
                    MOV [iSectionCount], ECX
                    XOR ECX, ECX
.loopsections:      PUSH EAX
                    PUSH EDX
                    PUSH EBX
                    PUSH ECX
                    Call ELF_Loadsection
                    POP ECX
                    POP EBX
                    INC ECX
                    POP EDX
                    POP EAX
                    ADD EDX, EAX
                    CMP [iSectionCount], ECX
                    JNE .loopsections

                    MOV EDX, [EBX+E_SHOFF]
                    ADD EDX, EBX
                    MOV [lpFileOffset], EBX
                    MOV [lpSectionTable], EDX
                    XOR EAX, EAX
                    XOR ECX, ECX
                    MOV AX, [EBX+E_SHENTSIZE]
                    MOV CX, [EBX+E_SHNUM]
                    MOV [iSectionLength], EAX
                    MOV [iSectionCount], ECX
.loopsections2:     PUSH ECX
                    PUSH EAX
                    PUSH EDX
                    PUSH EBX
                    Call ELF_Adjustsection
                    POP EBX
                    POP EDX
                    POP EAX
                    ADD EDX, EAX
                    POP ECX
                    DEC ECX
                    JNZ .loopsections2

                    ; Get the entry point
                    MOV EBX, [lpCurrentAppStart]                    

                    XOR EAX, EAX ; set ZF

                    RET
.fail:              OR AL, 1 ; clear ZF
                    RET


                    ;
                    ; Function: ELF_Loadsection
                    ; Parses an elf section and loads it into memory
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;     - ECX = current section index
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     unknown
                    ;
ELF_Loadsection:    MOV EAX, [EDX+SH_TYPE]
                    CMP EAX, SHT_PROGBITS
                    JNE .skip1
                    JMP ELF_Copysection
.skip1              CMP EAX, SHT_NOBITS
                    JNE .skip2
                    JMP ELF_Allocsection
.skip2              RET

;
                    ; Function: ELF_Adjustsection
                    ; Parses an elf relocation section and loads it into memory
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     unknown
                    ;
ELF_Adjustsection:  MOV EAX, [EDX+SH_TYPE]
                    CMP EAX, SHT_REL
                    JNE .skip1
                    JMP ELF_Relocatesection
.skip1              RET

                    ;
                    ; Function: ELF_Copysection
                    ; Copies a section from an ELF file to newly allocated memory
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;     - ECX = current section index
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     EAX, EDI
                    ;
ELF_Copysection:    PUSH EBX
                    PUSH EDX
                    MOV EAX, [EDX+SH_ADDR]
                    MOV EBX, [EDX+SH_SIZE]                    
                    MOV EDI, [lpCurrentBase]
                    MOV [lpSectionArray + 4*ECX], EDI
                    
                    ; check if this section contains the entry point
                    MOV ECX, [lpStoredAppStart] ; ECX = original entry point
                    SUB ECX, EAX
                    JC .noreloc
                    CMP ECX, EBX
                    JGE .noreloc
                    ADD ECX, EDI
                    MOV [lpCurrentAppStart], ECX
                    
.noreloc:                    
                    ADD EBX, PAGE_SIZE-1                    
                    SHR EBX, 12
                    kernel BlockAlloc
                    SHL EBX, 12
                    ADD [lpCurrentBase], EBX

                    POP EDX
                    POP EBX

                    MOV ECX, [EDX+SH_SIZE]
                    MOV ESI, [EDX+SH_OFFSET]
                    ADD ECX, 3
                    ADD ESI, [lpFileOffset]
                    SHR ECX, 2
                    CLD
                    REP MOVSD

                    RET

                    ;
                    ; Function: ELF_AllocSection
                    ; Parses an elf bss section header, allocates it and zeroes it
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;     - ECX = current section index
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     EAX, ECX, EDI
                    ;
ELF_Allocsection:   PUSH EBX
                    PUSH ECX
                    PUSH EDX
                    MOV EAX, [EDX+SH_ADDR]      ; EAX = virtual address of section 
                    MOV EBX, [EDX+SH_SIZE]      ; EBX = amount of bytes                    
                    MOV EDI, [lpCurrentBase]    ; EDI = current memory offset
                    MOV [lpSectionArray + 4*ECX], EDI
                    
                    ; check if this section contains the entry point
                    MOV ECX, [lpStoredAppStart] ; ECX = original entry point
                    SUB ECX, EAX
                    JC .noreloc
                    CMP ECX, EBX
                    JGE .noreloc
                    ADD ECX, EDI
                    MOV [lpCurrentAppStart], ECX

.noreloc:
                    ADD EBX, PAGE_SIZE-1        ; EBX = amount of bytes for rounding up
                    SHR EBX, 12                 ; EBX = amount of pages
                    kernel BlockAlloc           ; EBX = allocated size in pages
                    SHL EBX, 12                 ; EBX = allocated size in bytes
                    ADD [lpCurrentBase], EBX

                    MOV ECX, EBX                ; ECX = bytes
                    SHR ECX, 2                  ; ECX = dwords
                    XOR EAX, EAX                ; EAX = 0
                    REP STOSD                   ; Fill ebx bytes in this bss with zeroes

                    POP EDX
                    POP ECX
                    POP EBX
                    RET

ELF_Relocatesection:PUSH EBX
                    PUSH EDX
                    PUSH EBP
                    MOV ECX, [EDX+SH_SIZE]        ; ECX = size of relocate section
                    MOV ESI, [EDX+SH_OFFSET]      ; ESI = offset to relocation relative to start of file
                    ADD ESI, [lpFileOffset]       ; ESI = absolute address of relocate section

                    MOV EAX, [EDX+SH_INFO]        ; EAX = index to data section header
                    MOV EDI, EAX                  ; EDI = index to data section header
                    MOV EBX, [EDX+SH_LINK]        ; EBX = index to symbol table header
                    IMUL DWORD [iSectionLength]   ; EDX:EAX = offset into header table
                    ADD EAX, [lpSectionTable]     ; EAX = pointer to data section header                    
                    MOV EBP, [EAX+SH_ADDR]        ; EBP = original virtual address of segment
                    MOV EDI, [lpSectionArray + 4*EDI] ; EDI = pointer data segment to be altered

                    MOV EAX, EBX
                    IMUL DWORD [iSectionLength]
                    ADD EAX, [lpSectionTable]     ; EAX = pointer to symbol table header
                    MOV EBX, [EAX+SH_OFFSET]      ; EBX = relative pointer to symbol table
                    ADD EBX, [lpFileOffset]       ; EBX = pointer to symbol table

                    ; at this point, EAX and EDX are free
.looprel:           PUSH ECX
                    ; here EAX, ECX, and EDX are free
                    MOV EAX, [ESI+4]              ; relocation structure
                    MOV EDX, EAX                  ; copy
                    SHR EAX, 8                    ; get the section index
                    SHL EAX, 4                    ; get the section offset
                    CMP DL, 2                     ; compare relocation type
                    JE .pc32                      ; is IP-relative relocation
                    CMP DL, 1
                    JE .abs32                     ; is absolute relocation
                    HLT

.continue:          POP ECX
                    ADD ESI, 8
                    SUB ECX, 8
                    JNZ .looprel
                    POP EBP
                    POP EDX
                    POP EBX
                    RET

                    ; do R_386_PC32 relocation
.pc32:              ADD EAX, EBX                 ; EAX = pointer to symbol entry
                    XOR EDX, EDX
                    MOV DX, [EAX+ST_SHNDX]       ; EDX = section header
                    MOV ECX, EAX                 ; ECX = pointer to symbol entry
                    MOV EAX, [iSectionLength]
                    IMUL EDX                     ; EAX = relative section header offset
                    ADD EAX, [lpSectionTable]
                    MOV EDX, [EAX+SH_ADDR]
                    MOV ECX, [ESI]               ; ECX = virtual address to be modified
                    SUB ECX, EBP                 ; ECX = address to be modified relative to section
                    SUB EDX, EBP
                    ADD [EDI+ECX], EDX           ; commit to exectuable image
                    JMP .continue

                    ; do R_386_32 relocation
.abs32:             ADD EAX, EBX                 ; EAX = pointer to symbol entry
                    XOR EDX, EDX
                    MOV DX, [EAX+ST_SHNDX]       ; EDX = section index
                    MOV ECX, EDX                 ; ECX = section index
                    MOV EAX, [iSectionLength]
                    IMUL EDX                     ; EAX = relative section header offset
                    ADD EAX, [lpSectionTable]    ; EAX = pointer to section header where target resides
                
                    MOV EDX, [EAX+SH_ADDR]       ; EDX = Original virtual address of target section
                    MOV EAX, [lpSectionArray+4*ECX] ; EAX = New virtual address of target section
                    SUB EAX, EDX

                    MOV ECX, [ESI]               ; ECX = virtual address to be modified
                    SUB ECX, EBP                 ; ECX = address to be modified relative to section
                    ;ADD EAX, EDX
                    ADD [EDI+ECX], EAX           ; commit to exectuable image
                    JMP .continue


                    ; todo: get task entry point and create threads for all modules
CreateTask:         MOV EDI, [lpCurrentBase]
                    MOV EBX, lpcAppBase

                    ; fixme: create a thread rather than bruteforce starting things
                    ;kernel CreateThread
                    JMP EBX

                    ADD dword [lpCurrentBase], PAGE_SIZE * 2
                    JMP $

; ramdisk equates
RD_NAME             EQU 0
RD_SIZE             EQU 8
RD_OFFSET           EQU 12
RD_ENTRYSIZE        EQU 16

; offsets
lpcRamdiskBase      EQU 0x80000000
lpcAppBase          EQU 0xC0000000
lpcCommBase         EQU 0xCFFF0000
lpCurrentHeap       DD 0xD0000000

; vars
lpRamdisk:          DD 0
lpRamdiskEntry:     DD 0
iPhysRamdisk:       DD 0
lpLastBase:         DD 0
lpCurrentBase:      DD 0
lpStoredAppStart:   DD 0
lpCurrentAppStart:  DD 0
lpLoadTab:          DD 0
lpMessageStruct:    DD lpcCommBase + 8


lpFileOffset:       DD 0
lpSectionTable:     DD 0
iSectionCount:      DD 0
iSectionLength:     DD 0
iFilesize:          DD 0

lpSectionArray:     TIMES 64 DD 0
stack:    TIMES 256 DD 0
stackend: