ORG 400000h
BITS 32

;
; Summary: stage4_test.asm
; *The bootstrap user module*
;
; This is a replacement for the standard bootstrap
; in <stage4_load.asm>, which is designed to test
; kernel interfaces
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational purposes
;

; EAX = ramdisk address in linear memory

%include "inc_syscall.asm"
%include "inc_ia.asm"

STC
SBB ESI, ESI
MOV EDI, 0x700000
kernel CreateAddressSpace

mov esi, 0x10000000
mov edi, esi
mov ebx, 1
kernel BlockAllocPhysL

kernel KernelVersion
sbb esi, esi

mov eax, -1
int 0x81
sbb ebp, ebp

mov ebx, 2
mov edi, 0x4000
kernel BlockAlloc
sbb edi, edi

mov dword [0x4000], 0xb1ab1a


mov ebx, 2
mov edi, 0x8000
mov esi, 0x210000
kernel BlockAllocEx

mov dword [0x8000], 0xb1ab1a

mov esi, 0xA0000
mov edi, esi
mov ebx, 0x20000 / PAGE_SIZE
kernel BlockAllocPhys

; map IVT
xor esi, esi
mov edi, esi
mov ebx, 1
kernel BlockAllocPhys

; map VGA Bios
mov esi, 0xC0000
mov edi, esi
mov ebx, 0x10000 / PAGE_SIZE
kernel BlockAllocPhys

kernel Yield

STC
SBB ESI, ESI
MOV EDI, 0xD0000
MOV EBX, otherthread
XOR EDX, EDX
kernel CreateThread

; create thread in remote address space
; (1/3) create remote paging structures
MOV EDI, 0xD0000000
MOV EBX, 0x700000
STC
SBB ESI, ESI
kernel AllocatePageTableRemote

; (2/3) create remote mapping to code
MOV EBX, 0x700000
MOV ESI, 0x400000
MOV EDI, 0xD0000000
kernel TransferPage

; (3/3) create thread
STC
SBB ESI, ESI
MOV EBX, remotethread - 0x400000 + 0xD0000000
MOV EDI, 0x90000
MOV ECX, 0x700000
XOR EDX, EDX
kernel CreateThreadRemote


stickybitloop:
kernel Yield
cmp byte [stick], 0
inc word [0xB8000 + 160]
;JMP stickybitloop
JE stickybitloop

jmp print

otherthread:
        inc word [0xB8000]
        inc word [0xA0010]
        INC byte [stick]
        kernel Yield
        jmp otherthread
stick:  DB 0


remotethread:
        kernel Yield
        jmp remotethread


print:
        mov esi, msg.text
        mov edi, 0xB8000 + 24 * 160
        mov ecx, (msg.textend - msg.text)
        cld
        mov ah, 0x7
.loop:  LODSB
        STOSW
        DEC ECX
        JNZ .loop
        JMP .done

.done:
        mov ebx, 1
        mov edi, 0x10000
        kernel BlockAlloc

        mov edi, 0x10000
        mov esi, vmcode
        mov ecx, vmcode.end - vmcode
        rep movsb

        FNINIT
        MOVQ MM0, [$$]
        MOVAPS XMM0, [$$]


        MOV EDI, 0
        MOV EBX, 1
        STC
        SBB ESI, ESI
        kernel AllocateIoBitmap

        XCHG EBX, EBX   ; magicbreak

        ; test allocating extra page tables
        STC
        SBB ESI, ESI
        MOV EDI, 0x40000000
        kernel AllocatePageTable

        MOV EBX, 4
        MOV EDI, 0x40000000
        kernel BlockAlloc


; bruteforce ports :)
        MOV EDI, 0x0000
        MOV EBX, 0xF200
        kernel PortAlloc
        SBB ESI, ESI
        MOV EDI, 0x80
        MOV EBX, 0x1
        kernel PortAlloc
        SBB ESI, ESI


        MOV EDI, 0x3B4
        MOV EBX, 0x3E0-0x3B4
        kernel PortAlloc
        SBB ESI, ESI

; bochs port
        MOV EDI, 0x1ce
        MOV EBX, 0x4
        kernel PortAlloc
        SBB ESI, ESI

; v2k ports?
        MOV EDI, 0xF000
        MOV EBX, 0x200
        kernel PortAlloc
        SBB ESI, ESI
        MOV EDI, 0x80
        MOV EBX, 0x1
        kernel PortAlloc
        SBB ESI, ESI

        MOV ESI, 0x10000000 ; 0x1000:0x0000
        XOR EDI, EDI
        MOV EBX, vmretpos
        kernel EnterV8086

vmretpos:

        mov EBX, 0xB8000 + 312
        call printhex16
        MOV EDX, ESI
        mov EBX, 0xB8000 + 472
        call printhex16
        SHR EDX, 16
        mov EBX, 0xB8000 + 632
        call printhex16

        PUSH EDI
        MOV ECX, ESI
        AND ECX, 0xffff0000
        SHR ECX, 12
        ADD CX, SI
        MOV EDI, ECX
        MOV ECX, 8
        MOV EBX, 0xb8000 + 800 - 48
.loop:  MOV DH, [EDI]
        CALL printhex8
        INC EDI
        ADD EBX, 6
        DEC ECX
        JNZ .loop


        MOV EDI, 0xA0000
        MOV ECX, 320*200
        MOV AL, 0x01
        CLD
        REP STOSB

        POP EDI

        MOV word [0xB8000 + 156], 0x0702
        MOV EBX, vmretpos
        kernel EnterV8086



printhex16:
        MOV AH, 0x07
        MOV AL, DL
        AND AL, 0xF
        ADD AL, '0'
        MOV [EBX+6], AX
        MOV AL, DL
        SHR AL, 4
        ADD AL, '0'
        MOV [EBX+4], AX
printhex8:
        MOV AH, 0x07
        MOV AL, DH
        AND AL, 0xF
        ADD AL, '0'
        MOV [EBX+2], AX
        MOV AL, DH
        SHR AL, 4
        ADD AL, '0'
        MOV [EBX+0], AX
        RET



BITS 16
vmcode:
        MOV AX, 0xB800
        mov ES, AX
        MOV word [ES:158], 0x0701
        XOR AX, AX
        MOV FS, AX
        MOV AX, 0x1000
        XOR ESP, ESP
        MOV SS, AX
        MOV SP, 0x1000

; for testing VM handling
;        MOV EAX, 1
;        MOV DS, AX
;        MOV EBX, 2
;        MOV ES, BX
;        MOV ECX, 3
;        MOV FS, CX
;        MOV EDX, 4
;        MOV GS, DX
;        MOV ESI, 5
;        MOV SS, SI
;        MOV EDI, 6
;        MOV ESP, 7
;        MOV EBP, 8
;        int 0xff

        ; int 0x10
        MOV AX, 0x13
        PUSH EFLAGS_IF
        CALL FAR [FS:0x10*4]

        XOR EDX, EDX
        INT 0xff
        JMP $
.end:

msg:
.text: DB "Stage 4 loaded. That's all folks!"
.textend:
