;
; Summary: stage2_8_ia_efi.asm
; *The stage 2 bootloader for My Operating System (MOS)*
;
; - Loads stage 3 and ramdisk into memory
; - Determines memory map
; - Set a video mode with parameters
; - Take over from EFI services
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational purposes
;

[bits 64]

%include "inc_efi.asm"
[global _start]
[extern kernel_start]
[extern kernel_end]
[extern ramdisk_start]
[extern ramdisk_end]

SECTION .text

_start:		;XCHG BX, BX			; magic breakpoint
		SUB RSP, 0x38
		MOV [handle WRT RIP], RCX	; store program arguments for reuse
		MOV [efistruct WRT RIP], RDX	
		
		MOV RCX, [RDX + EFISYSTEMTABLE_CONSOLEOUTPROTO_OFF]
		MOV RAX, [RCX + EFI_STOP_OUTPUTSTRING_OFF]
		LEA RDX, [teststring WRT RIP]
		CALL RAX
		
		; get GOP handles
		; 1 = type  	RCX
		; 2 = *guid 	RDX
		; 3 = *key  	R8
		; 4 = *size 	R9
		; 5 = *buffer

		MOV RDX, [efistruct WRT RIP]
		LEA RAX, [GOPhandles WRT RIP]
		MOV RCX, [RDX + EFISYSTEMTABLE_BOOTSERVICES_OFF]
		MOV [RSP+0x20], RAX ;buffer pointer on stack
		MOV RAX, [RCX + EFIBOOTSERVICES_LOCATE_HANDLE_OFF]

		LEA RDX, [GOP_GUID WRT RIP]
		MOV RCX, EFI_LOCATE_BYPROTOCOL
		XOR R8, R8 ; unused
		LEA R9, [GOPhandlecount WRT RIP]
		;XCHG BX, BX
		CALL RAX

		; Get protocol
		; 1 = ProtoHandle	RCX
		; 2 = *Protocol GUID	RDX
		; 3 = **Interface	R8
		; 4 = AgentHandle	R9
		; 5 = ControllerHandle	
		; 6 = Attributes
		XOR RAX, RAX
		MOV RDX, [efistruct WRT RIP]
		MOV AL, EFI_OPEN_PROTOCOL_BY_HANDLE_PROTOCOL
		MOV RCX, [RDX + EFISYSTEMTABLE_BOOTSERVICES_OFF]
		MOV [RSP+0x28], RAX
		XOR RDX, RDX
		MOV RAX, [RCX + EFIBOOTSERVICES_OPEN_PROTOCOL_OFF]
		MOV [RSP+0x20], RDX
		MOV RCX, [GOPhandles WRT RIP]
		LEA RDX, [GOP_GUID WRT RIP]
		LEA R8,  [GOPprotocol WRT RIP]
		MOV R9,  [handle WRT RIP]
		;XCHG BX, BX
		CALL RAX
		;XCHG BX, BX
		
		; locate modes
		MOV [RSP+0x20], R14
		MOV [RSP+0x28], R15
		MOV R14, [GOPprotocol WRT RIP]
		MOV RDX, [R14 + EFI_GOP_MODE_OFF]
		MOV R15D, [RDX + EFI_GOP_MODE_MAXMODE_OFF] ;32-bits		
		
		; RAX,RCX,R9 in use
.modeloop:	DEC R15
		MOV RDX, R15
		MOV RCX, R14
		LEA R8, [GOPmodesize WRT RIP]
		LEA R9, [GOPmodeinfo WRT RIP]
		CALL [RCX + EFI_GOP_QUERY_MODE_OFF]
		
		MOV R8, [GOPmodeinfo WRT RIP]
		MOV R10D, [R8 + EFI_GOP_MODEINFO_H_RESOLUTION_OFF]
		MOV R11D, [R8 + EFI_GOP_MODEINFO_V_RESOLUTION_OFF]
		CMP R10D, 1024
		JNE .modeignore
		CMP R11D, 768
		JNE .modeignore
		MOV [GOPmode_x WRT RIP], R10D
		MOV [GOPmode_y WRT RIP], R11D
		MOV RDX, R15
		JMP .modechosen

.modeignore:	OR R15, R15		 
		JNZ .modeloop
		MOV RCX, [R14 + EFI_GOP_MODE_OFF]
		MOV RDX, [RCX + EFI_GOP_MODE_MAXMODE_OFF]
		DEC RDX ; last available mode
.modechosen:

		; GOP setmode
		; 1 = protocol
		; 2 = modenumber
		MOV RCX, R14
		;MOV RDX, 2
		CALL [RCX + EFI_GOP_SET_MODE_OFF]
		
		MOV RDX, [R14 + EFI_GOP_MODE_OFF]
		MOV RAX, [RDX + EFI_GOP_MODE_FRAMEBUFFERBASE_OFF]
		MOV [GOPmode_lfb WRT RIP], RAX

		XOR R8, R8
		XOR R9, R9
.yloop:
		MOV ECX, R9D
		SHL ECX, 16
		MOV R8D, 1024
.xloop:
		MOV [EAX], ECX
		ADD EAX, 4
		INC ECX
		DEC R8
		JNZ .xloop
		INC R9D
		CMP R9D, 768
		JNE .yloop		

		; restore saved registers
		MOV R14, [RSP+0x20]
		MOV R15, [RSP+0x28]

		; output
		MOV RDX, [efistruct WRT RIP]
		MOV RCX, [RDX + EFISYSTEMTABLE_CONSOLEINPROTO_OFF]
		MOV RAX, [RCX + EFI_STIP_RESET_OFF]
		MOV RDX, 0
		CALL RAX

.nokey:
		MOV RDX, [efistruct WRT RIP]
                MOV RCX, [RDX + EFISYSTEMTABLE_CONSOLEINPROTO_OFF]
                MOV RAX, [RCX + EFI_STIP_READ_KEY_OFF]
	        LEA RDX, [keystroke WRT RIP]
		CALL RAX

		MOV EAX, [keystroke WRT RIP]
		OR EAX, EAX
		JZ .nokey

		MOV RDX, [efistruct WRT RIP]
		MOV RCX, [RDX + EFISYSTEMTABLE_CONSOLEOUTPROTO_OFF]
	        MOV RAX, [RCX + EFI_STOP_OUTPUTSTRING_OFF]
                LEA RDX, [teststring2 WRT RIP]
                CALL RAX

		; GetMemoryMap
		MOV RDX, [efistruct WRT RIP]
		MOV RCX, [RDX + EFISYSTEMTABLE_BOOTSERVICES_OFF]
		MOV RAX, [RCX + EFIBOOTSERVICES_GET_MEMORY_MAP_OFF]
		; 1 = *MemoryMapSize RCX
		; 2 = *MemoryMap RDX
		; 3 = *MapKey R8
		; 4 = *DescriptorSize R9
		; 5 = *DescriptorVersion
		LEA RCX, [mmMapSize WRT RIP]
		MOV RDX, RCX
		MOV R8, RCX
		MOV R9, RCX
		MOV R10, RCX
		ADD RDX, mmMap-mmMapSize
		ADD R8,  mmMapKey-mmMapSize
		ADD R9,  mmDescriptorSize-mmMapSize
		ADD R10, mmDescriptorVersion-mmMapSize
		MOV [RSP+0x20], R10
		;XCHG BX, BX
		CALL RAX
		;XCHG BX, BX

		MOV RDX, [efistruct WRT RIP]
		MOV RCX, [RDX + EFISYSTEMTABLE_BOOTSERVICES_OFF]
		MOV RAX, [RCX + EFIBOOTSERVICES_EXIT_BOOT_SERVICES_OFF]
		MOV RCX, [handle WRT RIP]
		MOV RDX, [mmMapKey WRT RIP]
		CALL RAX
		;XCHG BX, BX

		; copy kernel to it's proper address
		LEA RSI, [kernel_start WRT RIP]
		MOV EDI, 0x100000
		LEA RCX, [kernel_end WRT RIP]
		SUB RCX, RSI
		SHR RCX, 3
		INC RCX
		REP MOVSQ

		;XCHG BX, BX
		LEA RDX, [gdt WRT RIP]
		MOV [gdtrp WRT RIP], RDX
		LGDT [gdtr WRT RIP]
		
		MOV EAX, 0x10
		MOV EDX, 0x00100000
		LEA RBP, [GOPmode WRT RIP]
		PUSH RAX
		PUSH RDX
		XCHG BX, BX
		O64 A64 RETF

		ADD RSP, 0x38
		XOR RAX, RAX			;success return
		RET

SECTION .data

handle: 	DQ 0
efistruct:	DQ 0
keystroke:	DW 0
keystroke2:	DW 0

teststring:	DW 'H','e','l','l','o',' ','W','o','r','l','d','!',13,10, 0
teststring2:	DW 'K','e','y','s','t','r','o','k','e','!',13,10, 0

ALIGN 8
GOP_GUID:	DD 0x9042a9de
		DW 0x23dc, 0x4a38
		DB 0x96,0xfb,0x7a,0xde,0xd0,0x80,0x51,0x6a
GOPhandles:	TIMES 8 DQ 0
GOPhandlecount: DQ $-GOPhandles
GOPprotocol:	DQ 0

GOPmodesize:	DQ 0
GOPmodeinfo:	DQ 0

GOPmode:
GOPmode_x:	DD 0
GOPmode_y:      DD 0
GOPmode_pitch:  DD 1024 * 4
GOPmode_format: DD 0
GOPmode_lfb:    DQ 0

gdtr:		DW 0x18
gdtrp:		DQ 0

gdt:		DQ 0
		DW 0xFFFF, 0, 0x9200,0x8F              ; flat data desciptor
		DW 0xFFFF, 0, 0x9A00,0xCF              ; code

mmMapSize:	DQ mmMapEnd-mmMap
mmMapKey:	DQ 0
mmDescriptorSize: DQ 0
mmDescriptorVersion: DQ 0
; apparently this needs to be huge... O.o
mmMap:		TIMES 2048 DB 0xcc
mmMapEnd:
