;
; Summary: stage3.asm [ia-pc]
; *The stage 3 / main kernel for My Operating System (MOS)*
;
; This module is responsible for managing and enabling the running of user applications
;
; For software programming, check the <System calls> section
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational purposes
;

ORG 100000h

BITS 32
CPU 386

%include "inc_ia.asm"
%include "inc_kernel.asm"
%include "inc_chips.asm"

; =============================================================================
; Group: Bootstrap
; These functions contain the first steps into starting the kernel
; =============================================================================

; kernel signature - stage2 needs it for verification
; kernel is called with [EBX]=bootloader struct, [EDX]=ramdisk

kernelimagestart:       times 4 NOP
			MOV EAX, CR0
			AND EAX, 0xffffffff-CR0_PG
			MOV CR0, EAX

                        MOV EAX, [EBP + 16]
			MOV [dwLFBOffset], EAX
			MOV EAX, [EBP + 8]
			MOV [dwLFBPitch], EAX

                        MOV EAX, kernelentry
                        MOV [lpRamdisk], EDX
                        MOV [lpBootloaderData], EBX
                        JMP EAX

times 64-$+kernelimagestart DB 0

                        DD Oops    ; cheap bochs debug stub
                        DD Yank 

dwLFBOffset:		DD 0
dwLFBPitch:		DD 1024*3

%include "../ia_common/print_lfb.asm"
%include "../ia_common/stage3.asm"


