#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef struct blocklist
{
    char * buffer;
    int buffersize;
    void * next;
} blocklist;

typedef struct objlist
{
    char name[8];
    blocklist * first;
    void * next;
    int totalsize;
} objlist;

static blocklist * readfile(const char * fn)
{
    FILE * f = fopen(fn, "rb");
    if (!f)
    {
        fprintf(stderr, "error reading %s\n", fn);
    return NULL;
    }

    blocklist * head = (blocklist *) malloc(sizeof(blocklist));
    blocklist * current = head;
    int done = 0;
    while (!done)
    {
        if (!current)
    {
            fprintf(stderr, "out of memory");
        return NULL;
    }
        current->buffer = malloc(4096);
    if (!current->buffer)
    {
            fprintf(stderr, "out of memory");
        return NULL;
    }

    int bytes = fread(current->buffer, 1, 4096, f);
    current->buffersize = bytes;
    if (bytes < 4096)
    {
        current->next = NULL;
        done = 1;
    } else {
        current->next = malloc(sizeof(blocklist));
        current = (blocklist *) current->next;
    }
    }

    fclose(f);

    return head;
}

static int getsize(blocklist * b)
{ 
    if (!b) return 0;
    return b->buffersize + getsize((blocklist*)(b->next));
}

static int writeblock(FILE * fout, blocklist * b)
{
    while(b)
    {
        if (fwrite(b->buffer, 1, b->buffersize, fout) != b->buffersize)
        {
            fprintf(stderr, "error writing block\n");
            return 1;                      
        }        
        b = (blocklist*) b->next;
    }       
    return 0;
}

int main(int argc, const char ** argv)
{
    if(argc < 3)
    {
        fprintf(stderr, "MOS ramdisk image creator\n");
        fprintf(stderr, "usage: %s output input [input...]\n", argv[0]);
        return 2;
    }

    int i = 0;
    objlist * head = NULL;
    for (i = 2; i < argc; i++)
    {
        blocklist * data = readfile(argv[i]);
        if (!data) return 1;

        objlist * entry = (objlist*) malloc(sizeof(objlist));
        if (!entry)
        {
            fprintf(stderr, "out of memory");
            return 3;
        }
        entry->next = head;
        entry->first = data;
        const char * last1 = strrchr(argv[i], '/');
        const char * last2 = strrchr(argv[i], '\\');
        if (last1) last1++; // skip slash as well
        if (last2) last2++;

        //printf("%s\n%s\n", last1, last2);

        if (!last1) last1 = last2;
        if (!last1) last1 = argv[i];
        if (last1 && last2 && (last2 < last1)) last1 = last2;

        int j;
        for (j = 0; j < 8; j++)
            entry->name[j] = ' ';
        int l = strlen(last1);
        if (l > 8) l = 8;
        strncpy(entry->name, last1, l);
        for (j = 0; j <8; j++)
            entry->name[j] = toupper(entry->name[j]);
        int endp = 8;
        for (j = 7; j >= 0; j--)
            if (entry->name[j] == '.') endp = j;
        for (j = endp; j < 8; j++)
            entry->name[j] = ' ';

        entry->totalsize = getsize(entry->first);
        //printf("data %i\n", entry->totalsize);

        head = entry;
    }

    FILE * fout = fopen(argv[1], "wb");
    if (!fout)
    {
        fprintf(stderr, "could not write file");
        return 2;
    }

    // emit header
    objlist * cur = head;
    int baseoffset = (argc-1) * 16;
    int offset = baseoffset;
    while (cur)
    {
        if (!fwrite(cur->name, 8, 1, fout))
        {
            fprintf(stderr, "write error");
            return 1;
        }
        int header2[2];
        header2[0] = cur->totalsize;        
        header2[1] = offset;
        if (!fwrite(header2, 8, 1, fout))
        {
            fprintf(stderr, "write error");
            return 1;
        }
        offset += cur->totalsize;
        offset += (16 - (cur->totalsize % 16)) % 16;
    
        //printf("header pointing at %x %x\n", header2[0], header2[1]);
        cur = (objlist *) cur->next;
    }
    char empty[16] = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
    if (!fwrite(empty, 16, 1, fout))
    {
        fprintf(stderr, "error filling");
    }
    
    cur = head;
    while(cur)
    {
        if (writeblock(fout, cur->first)) return 1;
        int gap = (16 - (cur->totalsize % 16)) % 16;
        if (gap) if (!fwrite(empty, gap, 1, fout))
        {
            fprintf(stderr, "error filling");
        }   
        cur = (objlist *) cur->next;
    }
    fclose(fout);
    return 0;
}


