;
; Summary: stage3.asm [ia-pc]
; *The pc hooks for stage 3 / main kernel for My Operating System (MOS)*
;
; Author:
;     Marcel Sondaar
;
; License:
;     <Public Domain>
;

ORG 100000h

BITS 32
CPU 386

%include "inc_ia.asm"
%include "inc_kernel.asm"
%include "inc_chips.asm"

; =============================================================================
; Group: Bootstrap
; These functions contain the first steps into starting the kernel
; =============================================================================


; kernel signature - stage2 needs it for verification
; kernel is called with [EBX]=bootloader struct, [EDX]=ramdisk

kernelimagestart:       times 4 NOP
                        MOV ESI, 0x80000
                        MOV EDI, 0x100000
                        MOV ECX, kernelimagesize
                        CLD
                        REP MOVSB
                        MOV EAX, kernelentry
                        MOV [lpRamdisk], EDX
                        MOV [lpBootloaderData], EBX
                        JMP EAX

times 64-$+kernelimagestart DB 0

                        DD Oops    ; cheap bochs debug stub
                        DD Yank 

mbmagic                 EQU 0x1BADB002
mbflags                 EQU 0x00010003
multiboot:              DD mbmagic
                        DD mbflags
                        DD 0-mbmagic-mbflags
                        DD multiboot
                        DD $$
                        DD kernelimageend
                        DD 0x400000
                        DD multibootentry
                        
multibootentry:         MOV [lpBootloaderData], EBX
                        MOV EDX, [EBX+24]               ; multiboot.mods_addr
                        MOV EAX, kernelentry
                        MOV EDX, [EDX]                  ; mod.start
                        MOV [lpRamdisk], EDX
                        JMP EAX

; include kernel modules
%include "../ia_common/print_vga.asm"
%include "../ia_common/stage3.asm"

