/* Summary: kernel.s
 * 
 * Main kernel file for the 68k version. At the moment it just prints a hello world in white-on-blue.
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 *
 */


.section .text
.cpu 68000

.globl start
.globl interrupt
.extern modmain

start:

.vdp:
        move.w  #0x8238,       (0xc00004)
        move.w  #0x8407,       (0xc00004)
        move.w  #0x8560,       (0xc00004)
        move.w  #0x8c00,       (0xc00004)
        move.w  #0x8f02,       (0xc00004)
        move.w  #0x9000,       (0xc00004)
        move.w  #0x8174,       (0xc00004)

.setpallette:

        move.l  #0xc0000000,   (0xc00004)
        lea     Colours,       %a4
        move.w  #1,            %d0

.loadcolours:
        move.w  (%a4)+,        (0xc00000)
        dbra    %d0,           .loadcolours

.setfont:
        move.w  #0x8f02,       (0xc00004)
        move.l  #0x40000000,   (0xc00004)
        lea     (FontData),    %a4
        move.w  #0x400,        %d0
.loadfont:
        move.w  (%a4)+,        (0xc00000)
        dbra    %d0,           .loadfont

.printmessage:
        move.w  #0x8f02,       (0xc00004)
        move.l  #0x62000003,   (0xc00004)
        lea     (Message),     %a4
        move.w  #31,           %d0
        clr.l   %d1
.loadmessage:
        move.b  (%a4)+,        %d1
        sub.b   #0x20,         %d1
        move.w  %d1,           (0xc00000)
        dbra    %d0,           .loadmessage

        move.l  #0x64000003,   (0xc00004)
        move.w  #31,           %d0
.loadmessage2:
        move.b  (%a4)+,        %d1
        sub.b   #0x20,         %d1
        move.w  %d1,           (0xc00000)
        dbra    %d0,           .loadmessage2

.ecode:
        move.l  #0x00E10000,   %a7
        bsr     modmain

.halt:
        bra     .halt

Colours:
        .word   0x0f73;
        .word   0x0fff;

Message:
        .ascii "          MOS/M68K-MD           "
        .ascii "         HELLO WORLD !          "

interrupt:
    rte
