/* Summary: romheader.s
 *
 * ROM Header file for the megadrive. Contains the IVT, rom info and bootcode.
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 *
 */

.section .setup
.cpu 68000

IVT:
    /* 0x00 - 0x0f */
    .long 0x00FFE000        /* intitial A7 */
    .long setupcode         /* reset vector */
    .long interrupt         /* bus error */
    .long interrupt         /* address error */
    .long interrupt         /* invalid opcode */
    .long interrupt         /* division by zero */
    .long interrupt         /* CHK */
    .long interrupt         /* TRAPV */
    .long interrupt         /* protection violation */
    .long interrupt         /* TRACE */
    .long interrupt         /* Line A */
    .long interrupt         /* Line F */
    .long interrupt         /* reserved */
    .long interrupt         /* coprocessor */
    .long interrupt         /* format error */
    .long interrupt         /* uninitialized interrupt */

    /* 0x10 - 0x17 */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */

    /* 0x18 - 0x20 */
    .long interrupt         /* spurious interrupt */
    .long interrupt         /* IRQ 1 */
    .long interrupt         /* IRQ 2 */
    .long interrupt         /* IRQ 3 */
    .long interrupt         /* IRQ 4 (Horizontal Retrace) */
    .long interrupt         /* IRQ 5 */
    .long interrupt         /* IRQ 6 (Vertical Retrace) */
    .long interrupt         /* IRQ 7 */

    /* 0x20 - 0x2f */
    .long interrupt         /* TRAP 0x0 */
    .long interrupt         /* TRAP 0x1 */
    .long interrupt         /* TRAP 0x2 */
    .long interrupt         /* TRAP 0x3 */
    .long interrupt         /* TRAP 0x4 */
    .long interrupt         /* TRAP 0x5 */
    .long interrupt         /* TRAP 0x6 */
    .long interrupt         /* TRAP 0x7 */
    .long interrupt         /* TRAP 0x8 */
    .long interrupt         /* TRAP 0x9 */
    .long interrupt         /* TRAP 0xa */
    .long interrupt         /* TRAP 0xb */
    .long interrupt         /* TRAP 0xc */
    .long interrupt         /* TRAP 0xd */
    .long interrupt         /* TRAP 0xe */
    .long interrupt         /* TRAP 0xf */

    /* 0x30 - 0x37 */
    .long interrupt         /* FPU Unordered Exception */
    .long interrupt         /* FPU Inexact */
    .long interrupt         /* FPU Division by zero */
    .long interrupt         /* FPU Underflow */
    .long interrupt         /* FPU Operand Error */
    .long interrupt         /* FPU Overflow */
    .long interrupt         /* FPU SNaN */
    .long interrupt         /* FPU Unimplemented data type */

    /* 0x37 - 0x3f */
    .long interrupt         /* MMU Configuration error */
    .long interrupt         /* MMU Illegal operation error */
    .long interrupt         /* MMU Page fault */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */
    .long interrupt         /* reserved */

BiosBlock:

	.ascii	"SEGA MEGA DRIVE "                                  /* Console Name */
	.ascii	"PUBLICDOMAIN '07"                                  /* Copyright Information */
	.ascii	"MOS/M68K-MegaDrive                              "  /* Domestic Name */
	.ascii	"MOS/M68K-MegaDrive                              "  /* Overseas Name */
	.ascii	"GM 00000000-00"                                    /* Serial Number */
	.byte	0xa5, 0xFB                                          /* Checksum */
	.ascii	"JD              "                                  /* I/O Support */
	.long	0x00000000                                          /* ROM Start Address */
	.long	ROMEnd                                              /* ROM End Address */
	.long	0x00FF0000                                          /* Start of Backup RAM */
	.long	0x00FFFFFF                                          /* End of Backup RAM */
	.ascii	"                        "                          /* Modem Support */
	.ascii	"                                        "          /* Memo */
	.ascii	"JUE             "                                  /* Country Support */

setupcode:
	move.b  (0xA10001),	%D0
	and.b   #0x0F,		%D0
	beq     .wrongversion
	move.l  #0x53454741,  (0xA14000)
.wrongversion:
    bra     start
