;
; Summary: outportb.asm
; *outportb implementation for libx86*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

SECTION .text

global outportb

;
; Function: outportb
; writes a byte to an x86 i/o port
;
; in:
;     - Stack(1) = port to access
;     - Stack(2) = value to write
;
; out:
;     none
;

outportb:   MOV DX, [ESP+1*4]           ; DX = stack(1)
            MOV AL, [ESP+2*4]           ; AL = stack(2)
            OUT DX, AL                  ; write
            RET
