;
; Summary: allocateiobitmap.asm
; *PortAlloc cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global allocateiobitmap


;
; Function: allocateiobitmap
; Request i/o ports from the kernel
;
; in:
;     - Stack(1) = Starting port to contain
;     - Stack(2) = Amount of ports to contain
;     - Stack(3) = starting location in physical memory
;
; out:
;     Return = zero on success
;

allocateiobitmap:
    PUSH EBX
    PUSH EDI
    PUSH ESI

    MOV EDI, [ESP+4*4]
    MOV EBX, [ESP+5*4]
    MOV ESI, [ESP+6*4]

    kernel AllocateIoBitmap

    SBB EAX, EAX

    POP ESI
    POP EDI
    POP EBX
    RET