;
; Summary: allocateirbitmap.asm
; *AllocateIRBitmap cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global allocateirbitmap


;
; Function: allocateirbitmap
; Request for allocating the Interrupt Redirection Bitmap
;
; in:
;     - Stack(1)) = Base address in physical memory to mount
;
; out:
;     Return = Amount allocated
;

allocateirbitmap:
    PUSH EBX
    PUSH EDX
    PUSH EDI
    PUSH ESI

    MOV ESI, [ESP+5*4]

    kernel AllocateIRBitmap

    SBB EAX, EAX
    POP ESI
    POP EDI
    POP EDX
    POP EBX
    RET
