;
; Summary: allocatepagetable.asm
; *BlockAlloc cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global allocatepagetable


;
; Function: allocatepagetable
; Request memory from the kernel
;
; in:
;     - Stack(1) = Address to map page table
;     - Stack(2) = Address in memory to use
;
; out:
;     Return = Amount allocated
;

allocatepagetable:
    PUSH EBX
    PUSH EDX
    PUSH EDI
    PUSH ESI

    MOV ESI, [ESP+5*4]
    MOV EDI, [ESP+4*4]

    kernel AllocatePageTable

    SBB EAX, EAX
    POP ESI
    POP EDI
    POP EDX
    POP EBX
    RET
