;
; Summary: blockallocexl.asm
; *BlockAllocEx cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global blockallocexl


;
; Function: blockallocexl
; Request memory from the kernel
;
; in:
;     - Stack(1) = Amount to allocate in large pages
;     - Stack(2) = Base address to mount
;     - Stack(3) = Base address in physical memory to mount
;
; out:
;     Return = Amount allocated
;

blockallocexl:
    PUSH EBX
    PUSH EDX
    PUSH EDI
    PUSH ESI

    MOV EBX, [ESP+5*4]
    MOV EDI, [ESP+6*4]
    MOV ESI, [ESP+7*4]

    kernel BlockAllocExL

    MOV EAX, EBX
    POP ESI
    POP EDI
    POP EDX
    POP EBX
    RET
