;
; Summary: blockdealloc.asm
; *BlockDealloc cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global blockdealloc


;
; Function: blockdealloc
; Request memory from the kernel
;
; in:
;     - Stack(1) = Amount to allocate in pages
;     - Stack(2) = Base address to mount
;
; out:
;     Return = Pointer to the last byte freed
;

blockdealloc:
    PUSH EBX
    PUSH ESI
    PUSH EDI

    MOV ESI, [ESP+4*4]
    MOV EDI, [ESP+5*4]

    kernel BlockDealloc

    POP EDI
    POP ESI
    POP EBX
    RET
