;
; Summary: createthreadremote.asm
; *Thread creation wrapper for high-level languages*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global createthreadremote


;
; Function: createthreadremote
; Request memory from the kernel
;
; in:
;     - Stack(1) = Starting address of the new thread
;     - Stack(2) = Starting value for the stackpointer
;     - Stack(3) = Location in memory to use
;     - Stack(4) = Remote virtual address to map the thread structure
;     - Stack(5) = Handle of the remote address space
;
; out:
;     EAX - the status of the operation
;

createthreadremote:
                PUSH ESI
                PUSH EDI
                PUSH EBX
                PUSH EDX

                ;Declare Function createthreadremote Cdecl Alias "createthreadremote" (ByVal startaddress As Long, ByVal startstack As Byte Ptr, ByVal phys As Byte Ptr, ByVal dest As Byte Ptr, ByVal space As Long) As Long
                MOV EBX, [ESP+5*4]
                MOV EDX, [ESP+6*4]
                MOV ESI, [ESP+7*4]
                MOV EDI, [ESP+8*4]
                MOV ECX, [ESP+9*4]

                kernel CreateThreadRemote

                SBB EAX, EAX

                POP EDX
                POP EBX
                POP EDI
                POP ESI
                RET



