;
; Summary: enterv8086.asm
; *V8086 Mode wrapper for high-level languages*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global enterv8086


;
; Function: enterv8086
; Request memory from the kernel
;
; in:
;     - Stack(1) = Pointer to a structure containing the relevant data
;
; out:
;     Nothing - the passed structure is updated.
;

enterv8086:     PUSH ESI
                PUSH EDI
                PUSH EBX
                PUSH EBP
                PUSH EDX
                MOV [oldstack], ESP
                MOV EAX, [ESP+6*4]
                MOV ESI, [EAX]
                MOV EDI, [EAX+4]

                MOV EBX, .vmreturn
                kernel EnterV8086

.vmreturn:      MOV [vmstack], ESP
                MOV ESP, [oldstack]

                MOV EAX, [ESP+6*4]
                MOV [EAX], ESI
                MOV ESI, [vmstack]
                MOV [EAX+4], EDI
                MOV [EAX+8], EDX
                MOV [EAX+12], ESI

                POP EDX
                POP EBP
                POP EBX
                POP EDI
                POP ESI
                RET

SECTION .data

oldstack:   DD 0
vmstack:    DD 0

