;
; Summary: managememoryl1.asm
; *ManageMemoryL1 cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global managememoryl1


;
; Function: managememoryl1
; Request memory from the kernel
;
; in:
;     - Stack(1) = Address to manage
;     - Stack(2) = Page to use
;
; out:
;     Return = clear on success, set on error
;

managememoryl1:
    PUSH EBX
    PUSH EDX
    PUSH EDI

    MOV ESI, [ESP+4*4]
    MOV EDI, [ESP+5*4]

    kernel ManageMemoryL1

    SBB EAX, EAX
    POP EDI
    POP EDX
    POP EBX
    RET
