;
; Summary: managememoryl2.asm
; *ManageMemoryL1 cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global managememoryl2


;
; Function: managememoryl2
; Request memory from the kernel
;
; in:
;     - Stack(1) = Address to manage
;     - Stack(2) = Page to use
;
; out:
;     Return = clear on success, set on error
;

managememoryl2:
    PUSH EBX
    PUSH EDX
    PUSH EDI

    MOV ESI, [ESP+4*4]
    MOV EDI, [ESP+5*4]

    kernel ManageMemoryL2

    SBB EAX, EAX
    POP EDI
    POP EDX
    POP EBX
    RET
