;
; Summary: setredirectbits.asm
; *SetRedirectBits cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global setredirectbits


;
; Function: setredirectbits
; Set bits in the Interrupt Redirection Bitmap
;
; in:
;     - Stack(1) = Starting interrupt number
;     - Stack(2) = Interrupts to modify
;     - Stack(3) = Bit status
;
; out:
;     Return = Amount allocated
;

setredirectbits:
    PUSH EBX
    PUSH EDX
    PUSH EDI
    PUSH ESI

    MOV ESI, [ESP+5*4]
    MOV EDI, [ESP+6*4]
    MOV EBX, [ESP+7*4]

    kernel SetRedirectBits

    MOV EAX, EBX
    POP ESI
    POP EDI
    POP EDX
    POP EBX
    RET
