;
; Summary: transferpage.asm
; *Page duplication wrapper for high-level languages*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global transferpage


;
; Function: transferpage
; Request memory from the kernel
;
; in:
;     - Stack(1) = Location of the page in the current address space
;     - Stack(2) = Location of the page in the remote address space
;     - Stack(3) = Handle of the remote address space
;
; out:
;     EAX - the status of the operation
;

transferpage:
                PUSH ESI
                PUSH EDI
                PUSH EBX
                PUSH EDX

                MOV ESI, [ESP+5*4]
                MOV EDI, [ESP+6*4]
                MOV EBX, [ESP+7*4]
            
                kernel TransferPage

                SBB EAX, EAX

                POP EDX
                POP EBX
                POP EDI
                POP ESI
                RET



