;
; Summary: outportd.asm
; *outportd implementation for libx86*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

SECTION .text

global outportd

;
; Function: outportd
; writes a 32-bit doubleword to an x86 i/o port
;
; in:
;     - Stack(1) = port to access
;     - Stack(2) = value to write
;
; out:
;     none
;

outportd:   MOV DX, [ESP+1*4]           ; DX = stack(1)
            MOV EAX, [ESP+2*4]          ; EAX = stack(2)
            OUT DX, EAX                 ; write
            RET
