;
; Summary: outportw.asm
; *outportw implementation for libx86*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

SECTION .text

global outportw

;
; Function: outportw
; writes a 16-bit word to an x86 i/o port
;
; in:
;     - Stack(1) = port to access
;     - Stack(2) = value to write
;
; out:
;     none
;

outportw:   MOV DX, [ESP+1*4]           ; DX = stack(1)
            MOV AX, [ESP+2*4]           ; AL = stack(2)
            OUT word DX, AX             ; AX = result
            RET
