;
; Summary: tac.asm
; *test-and-clear for x86*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

SECTION .text

global TaC

;
; Function: TaC
; clears a bit in a byte, and return the original
;
; in:
;     - Stack(1) = address of the bit to access
;
; out:
;     Return = original bit's value (0 if clear, nonzero if set)
;

TaC:        MOV EDX, [ESP+1*4]      ; DX = stack(1)
            LOCK BTR word [EDX], 0
            SBB EAX, EAX
            RET
