;
; Summary: blockalloc.asm
; *BlockAlloc cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global blockalloc


;
; Function: blockalloc
; Request memory from the kernel
;
; in:
;     - Stack(1) = Amount to allocate in bytes
;     - Stack(2) = Base address to mount
;
; out:
;     Return = Amount allocated
;

blockalloc:
    PUSH EBX
    PUSH EDX
    PUSH EDI

    MOV EBX, [ESP+4*4]
    MOV EDI, [ESP+5*4]

    kernel BlockAlloc

    MOV EAX, EBX
    POP EBX
    POP EDX
    POP EDI
    RET