;
; Summary: createvtask.asm
; *MemMap cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global createvtask


;
; Function: createvtask
; Create a V8086 Task
;
; in:
;     - Stack(1) = CS:IP address
;     - Stack(2) = Location to allocate taskset
;
; out:
;     Return = success status
;

createvtask:
    PUSH EBX
    PUSH EDX
    PUSH EDI
    PUSH ESI

    MOV EBX, [ESP+5*4]
    MOV EDI, [ESP+6*4]

    kernel CreateVTask

    SBB EAX, EAX

    POP ESI
    POP EBX
    POP EDX
    POP EDI
    RET