;
; Summary: gatelookup.asm
; *<GateLookup> cdecl interface to the kernel*
;

%include "inc_syscall.asm"

SECTION .text

global gatelookup


;
; Function: gatelookup
; Find a port given its name
;
; in:
;     Stack(1) - The gate requested
;     Stack(2) - Pointer to an int to be filled with the address
;
; out:
;     Return = Address Space where the handler is situated
;

gatelookup:
    PUSH EBX

    MOV EBX, [ESP+2*4]

    kernel GateLookup

    MOV EDX, [ESP+3*4]
    OR EDX, EDX
    JZ .skip
    MOV [EDX], EBX
.skip:

    POP EBX
    RET
