;
; Summary: getcpuinfo.asm
; *GetCpuInfo cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global getcpuinfo


;
; Function: getcpuinfo
; Request memory from the kernel
;
; in:
;     - Stack(1) = Processor to query
;     - Stack(2) = Pointer to info structure to be filled
;
; out:
;     Return = success status
;

getcpuinfo:
                PUSH EBX
                PUSH EDI
                PUSH ESI

                MOV EBX, [ESP+4*4]

                kernel GetCpuInfo

                JC .done
                PUSH EBP
                MOV EBP, [ESP+6*4]
                MOV [DS:EBP     ], EDI
                MOV [DS:EBP+0x04], EAX
                MOV [DS:EBP+0x08], ESI
                MOV [DS:EBP+0x0c], EBX
                MOV [DS:EBP+0x10], EDX
                MOV [DS:EBP+0x14], ECX
                POP EBP

.done:          SBB EAX, EAX
                POP ESI
                POP EBX
                POP EDI
                RET