;
; Summary: ipccdeclconv.asm
; *ipc convention to cdecl convention wrapper*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

SECTION .text
GLOBAL ipccdeclconv

; Function: ipccdeclconv
; stub to retrieve the ipc parameters for a cdecl function
;
; in:
;     stack(1) - pointer to a function that contains the actual handler
;
; out:
;     nothing
;
; This stub assumes that the compiler hasn't changed the registers
; used for the call. Normally, manually writing out an appropriate asm stub
; is more efficient and secure, as it avoids a function pointer indirection,
; as well as some possible code optimisation that might break this code.
;
; to make sure the compiler doesnt destroy the registers, put one and only
; one call to this function as the only thing in the registered handler
; function
;
; Example (C):
;
;     void stub(void) {
;         ipccdeclconv(actualhandler);
;     }
;
; Example (Basic):
;     Sub stub()
;         Call ipccdeclconv(@actualhandler)
;     End Sub
;

ipccdeclconv:   PUSH EDI                ; EDI is the 4th parameter
                PUSH ESI                ; ESI is the 3rd parameter
                PUSH EBX                ; EBX is the 2nd parameter
                PUSH EAX                ; EAX is the 1st parameter
                MOV EDX, [ESP+5*4]      ; get the target's address
                CALL EDX                ; and call the handler
                POP EAX                 ; restore the values to their registers
                POP EBX                 ;
                POP ESI                 ;
                POP EDI                 ;
                RET                     ; return to the source
