;
; Summary: localipccall.asm
; *cdecl to local ipc wrapper*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

SECTION .text
GLOBAL localipccall

; Function: localipccall
; performs an ipc call to a handler in the local address space
;
; in:
;     stack(1) - handler's address
;     stack(2) - pointer to the first parameter
;     stack(3) - pointer to the second parameter
;     stack(4) - pointer to the third parameter
;     stack(5) - pointer to the fourth parameter
;
; out:
;     [ stack(2) ] - first returned parameter
;     [ stack(3) ] - second returned parameter
;     [ stack(4) ] - third returned parameter
;     [ stack(5) ] - fourth returned parameter
;     return       - success status
;
; note that you can not supply NULL pointers as these are filled without checking
;
localipccall:   PUSH ESI
                PUSH EDI
                PUSH EBX

                MOV EDX, [ESP+4*4]
                MOV EDI, [ESP+8*4]
                MOV ESI, [ESP+7*4]
                MOV EBX, [ESP+6*4]
                MOV ECX, [ESP+5*4]
                MOV EDI, [EDI]
                MOV ESI, [ESI]
                MOV EBX, [EBX]
                MOV EAX, [ECX]

                Call EDX

                MOV ECX, [ESP+5*4]
                MOV EDX, [ESP+6*4]
                MOV [ECX], EAX
                MOV [EDX], EBX

                MOV ECX, [ESP+7*4]
                MOV EDX, [ESP+8*4]
                MOV [ECX], ESI
                MOV [ECX], EDI

                POP EBX
                POP EDI
                POP ESI
                SBB EAX, EAX

                RET
