;
; Summary: memmap.asm
; *MemMap cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global memmap


;
; Function: memmap
; Request memory from the kernel
;
; in:
;     - Stack(1) = Amount to allocate in pages
;     - Stack(2) = Base address to mount
;     - Stack(3) = Target address to mount
;
; out:
;     Return = success status
;

memmap:
    PUSH EBX
    PUSH EDX
    PUSH EDI
    PUSH ESI

    MOV EBX, [ESP+5*4]
    MOV EDI, [ESP+6*4]
    MOV ESI, [ESP+7*4]

    kernel MemMap

    SBB EAX, EAX

    POP ESI
    POP EBX
    POP EDX
    POP EDI
    RET