;
; Summary: portalloc.asm
; *PortAlloc cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global portalloc


;
; Function: portalloc
; Request i/o ports from the kernel
;
; in:
;     - Stack(1) = Starting port to request
;     - Stack(2) = Amount of ports to request
;
; out:
;     Return = amount of ports allocated
;

portalloc:
    PUSH EBX
    PUSH EDI
    PUSH ESI

    MOV EDI, [ESP+4*4]
    MOV EBX, [ESP+5*4]

    kernel PortAlloc

    POP ESI
    POP EBX
    POP EDI
    RET