;
; Summary: routealloc.asm
; *<RouteAlloc> cdecl interface to the kernel*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

%include "inc_syscall.asm"

SECTION .text

global routealloc


;
; Function: routealloc
; Publicate a named port
;
; in:
;     - Stack(1) = Port
;     - Stack(2) = Name
;
; out:
;     Return = nonzero on failure
;

routealloc:
    PUSH EBX
    PUSH EDI

    MOV EDI, [ESP+3*4]
    MOV EBX, [ESP+4*4]

    kernel RouteAlloc

    SBB EAX, EAX

    POP EDI
    POP EBX
    RET