/*
        Summary: isalnum.c
        *implementation of the libc isalnum call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: isalnum
   Returns nonzero when c is either a character or a number */

int isalnum(int c)
{
    if(isalpha(c)) return(true);
    if(isdigit(c)) return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isalnum(0x0) == false);
    TESTCASE( isalnum(' ') == false);
    TESTCASE( isalnum(0x7) == false);
    TESTCASE( isalnum('\n') == false);
    TESTCASE( isalnum('0') == true);
    TESTCASE( isalnum('a') == true);
    TESTCASE( isalnum('A') == true);
    TESTCASE( isalnum('z') == true);
    TESTCASE( isalnum('Z') == true);
    return(TEST_RESULTS);
}

#endif
