/*
        Summary: isalpha.c
        *implementation of the libc isalpha call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: isalpha
   Returns nonzero when c is an alphanumerical character */

int isalpha(int c)
{
    if (c >= 'A' && c <= 'Z') return(true);
    if (c >= 'a' && c <= 'z') return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isalpha(0x0) == false);
    TESTCASE( isalpha(' ') == false);
    TESTCASE( isalpha(0x7) == false);
    TESTCASE( isalpha('0') == false);
    TESTCASE( isalpha('a') == true );
    TESTCASE( isalpha('A') == true );
    TESTCASE( isalpha('Z') == true );
    return(TEST_RESULTS);
}

#endif
