/*
        Summary: iscntrl.c
        *implementation of the libc iscntrl call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: iscntrl
   Returns nonzero when c is a control character */

int iscntrl(int c)
{
    if(c > 32) return(false);
    if(isspace(c)) return(false);

    return(true);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( iscntrl(0x0) == true );
    TESTCASE( iscntrl(' ') == false);
    TESTCASE( iscntrl(0x7) == true );
    TESTCASE( iscntrl('0') == false);
    TESTCASE( iscntrl('a') == false);
    TESTCASE( iscntrl('A') == false);
    TESTCASE( iscntrl('Z') == false);
    return(TEST_RESULTS);
}

#endif
