/*
        Summary: isdigit.c
        *implementation of the libc isdigit call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: isdigit
   Returns nonzero when c is a decimal digit (number) */

int isdigit(int c)
{
    if (c >= '0' && c <= '9') return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isdigit(0x0) == false);
    TESTCASE( isdigit(' ') == false);
    TESTCASE( isdigit(0x7) == false);
    TESTCASE( isdigit('\n') == false);
    TESTCASE( isdigit('0') == true);
    TESTCASE( isdigit('a') == false);
    TESTCASE( isdigit('A') == false);
    TESTCASE( isdigit('z') == false);
    TESTCASE( isdigit('Z') == false);
    TESTCASE( isdigit('9') == true);
    return(TEST_RESULTS);
}

#endif
