/*
        Summary: isgraph.c
        *implementation of the libc isgraph call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: isgraph
   Returns nonzero when c is printable character, excluding space */

int isgraph(int c)
{
    if (c > 32) return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isgraph(0x0) == false);
    TESTCASE( isgraph(' ') == false);
    TESTCASE( isgraph(0x7) == false);
    TESTCASE( isgraph('0') == true);
    TESTCASE( isgraph('a') == true);
    TESTCASE( isgraph('A') == true);
    TESTCASE( isgraph('z') == true);
    TESTCASE( isgraph('.') == true);
    TESTCASE( isgraph('?') == true);
    TESTCASE( isgraph(':') == true);
    return(TEST_RESULTS);
}

#endif
