/*
        Summary: islower.c
        *implementation of the libc islower call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: islower
   Returns nonzero when c is an lowercase character */

int islower(int c)
{
    if (c >= 'a' && c <= 'z') return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( islower(0x0) == false);
    TESTCASE( islower(' ') == false);
    TESTCASE( islower(0x7) == false);
    TESTCASE( islower('0') == false);
    TESTCASE( islower('a') == true);
    TESTCASE( islower('A') == false);
    TESTCASE( islower('z') == true);
    return(TEST_RESULTS);
}

#endif
