/*
        Summary: isprint.c
        *implementation of the libc isprint call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: isprint
   Returns nonzero when c is printable character, including space */

int isprint(int c)
{
    if (c >= 32) return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isprint(0x0) == false);
    TESTCASE( isprint(' ') == true);
    TESTCASE( isprint(0x7) == false);
    TESTCASE( isprint('\n') == false);
    TESTCASE( isprint('0') == true);
    TESTCASE( isprint('a') == true);
    TESTCASE( isprint('A') == true);
    TESTCASE( isprint('z') == true);
    TESTCASE( isprint('Z') == true);
    return(TEST_RESULTS);
}

#endif
