/*
        Summary: ispunct.c
        *implementation of the libc ispunct call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: ispunct
   Returns nonzero when c is a punctuation character (c is not a control, space, letter or number) */

int ispunct(int c)
{
    if (c <= 32) return(false);
    if (isalnum(c)) return(false);
    if (isspace(c)) return(false);
    return(true);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( ispunct(0x0) == false);
    TESTCASE( ispunct(' ') == false);
    TESTCASE( ispunct(0x7) == false);
    TESTCASE( ispunct('0') == false);
    TESTCASE( ispunct('a') == false);
    TESTCASE( ispunct('A') == false);
    TESTCASE( ispunct('z') == false);
    TESTCASE( ispunct('.') == true);
    TESTCASE( ispunct('?') == true);
    TESTCASE( ispunct(':') == true);
    return(TEST_RESULTS);
}

#endif
