/*
        Summary: isspace.c
        *implementation of the libc isspace call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <stdbool.h>
#include <ctype.h>

/* Function: isspace
   Returns nonzero when c is a whitespace character */

int isspace(int c)
{
    if(c == ' ') return(true);
    if(c == '\n') return(true);
    if(c == '\r') return(true);
    if(c == '\t') return(true);
    if(c == '\f') return(true);
    if(c == '\v') return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isspace(0x0) == false);
    TESTCASE( isspace(' ') == true);
    TESTCASE( isspace(0x7) == false);
    TESTCASE( isspace('\t') == true);
    TESTCASE( isspace('\n') == true);
    TESTCASE( isspace('\v') == true);
    TESTCASE( isspace('\r') == true);
    TESTCASE( isspace('\f') == true);
    TESTCASE( isspace('0') == false);
    TESTCASE( isspace('a') == false);
    TESTCASE( isspace('A') == false);
    TESTCASE( isspace('z') == false);
    return(TEST_RESULTS);
}

#endif
