/*
        Summary: isupper.c
        *implementation of the libc isupper call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: isupper
   Returns nonzero when c is an uppercase character */

int isupper(int c)
{
    if (c >= 'A' && c <= 'Z') return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isupper(0x0) == false);
    TESTCASE( isupper(' ') == false);
    TESTCASE( isupper(0x7) == false);
    TESTCASE( isupper('\n') == false);
    TESTCASE( isupper('0') == false);
    TESTCASE( isupper('a') == false);
    TESTCASE( isupper('A') == true);
    TESTCASE( isupper('z') == false);
    TESTCASE( isupper('Z') == true);
    return(TEST_RESULTS);
}

#endif
