/*
        Summary: isxdigit.c
        *implementation of the libc isxdigit call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>
#include <stdbool.h>

/* Function: isxdigit
   Returns nonzero when c is an hexadecimal digit  */

int isxdigit(int c)
{
    if (c >= '0' && c <= '9') return(true);
    if (c >= 'A' && c <= 'F') return(true);
    if (c >= 'a' && c <= 'f') return(true);
    return(false);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( isxdigit(0x0) == false);
    TESTCASE( isxdigit(' ') == false);
    TESTCASE( isxdigit(0x7) == false);
    TESTCASE( isxdigit('0') == true);
    TESTCASE( isxdigit('a') == true);
    TESTCASE( isxdigit('A') == true);
    TESTCASE( isxdigit('z') == false);
    return(TEST_RESULTS);
}

#endif
