/*
        Summary: tolower.c
        *implementation of the libc tolower call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>

/* Function: tolower
   Returns the lowercase version of a character */

int tolower(int c)
{
    if(c < 'A' || c > 'Z') return(c);
    return(c - 'A' + 'a');
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( tolower(0x0) == 0x0);
    TESTCASE( tolower(' ') == ' ');
    TESTCASE( tolower('0') == '0');
    TESTCASE( tolower('a') == 'a');
    TESTCASE( tolower('A') == 'a');
    TESTCASE( tolower('z') == 'z');
    TESTCASE( tolower('Z') == 'z');
    return(TEST_RESULTS);
}

#endif
