/*
        Summary: toupper.c
        *implementation of the libc toupper call*
        
        manually added to pdclib

        Author:
            Marcel Sondaar

        Licence:
            Public Domain
*/

#include <ctype.h>

/* Function: toupper
   Returns the uppercase version of a character */

int toupper(int c)
{
    if(c < 'a' || c > 'z') return(c);
    return(c - 'a' + 'A');
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( toupper(0x0) == 0x0);
    TESTCASE( toupper(' ') == ' ');
    TESTCASE( toupper('0') == '0');
    TESTCASE( toupper('a') == 'A');
    TESTCASE( toupper('A') == 'A');
    TESTCASE( toupper('z') == 'Z');
    TESTCASE( toupper('Z') == 'Z');
    return(TEST_RESULTS);
}

#endif
