/*
        Summary:  allocpages.c
        *pdclib interface to the kernel's memory management functions*
        
        Author:
            Marcel Sondaar

        License:
            Public Domain

*/

#include <stdlib.h>
#include <_PDCLIB_glue.h>

/* declaration of the asm call */
int _PDCLIB_dorequestpages(int size, char * base);

// Variable: _PDCLIB_heaptop
// contains the current top-of-heap
char * _PDCLIB_heaptop = (char *) 0x10000000;

/*
     Function: _PDCLIB_allocpages
     Allocate or deallocate pages from the heap

     in:
         - n = amount of blocks of _PDCLIB_PAGESIZE to allocate

     out:
         - return = original end-of-heap
*/

void * _PDCLIB_allocpages( int n )
{
    if (n < 0) return(NULL);

    char * prevtop = _PDCLIB_heaptop;

    int addedsize = _PDCLIB_dorequestpages(n, _PDCLIB_heaptop);
    if (addedsize == 0) return(NULL);

    _PDCLIB_heaptop += addedsize * _PDCLIB_PAGESIZE;
    if (addedsize < n) return(NULL);

    return(prevtop);
}

#ifdef TEST
#include <_PDCLIB_test.h>
#include <stdint.h>

int main( void )
{
    BEGIN_TESTS;
    void * baseptr = _PDCLIB_allocpages(1);
    TESTCASE( (uintptr_t) _PDCLIB_allocpages(1) - (uintptr_t)baseptr == _PDCLIB_PAGESIZE );
    TESTCASE( (uintptr_t) _PDCLIB_allocpages(2) - (uintptr_t)baseptr == 3 * _PDCLIB_PAGESIZE );
    return TEST_RESULTS;
}

#endif
