;
; Summary:  allocpagescall.asm
; *The asm stubs needed for allocpages.c to interface with the kernel*
;

%include "inc_syscall.asm"

SECTION .text

global _PDCLIB_dorequestpages


;
; Function: _PDCLIB_dorequestpages
; Request memory from the kernel
;
; in:
;     - Stack(1) = Amount to allocate
;     - Stack(2) = Base address to mount
;
; out:
;     Return = Amount allocated
;
; destroyed:
;     (none)
;

_PDCLIB_dorequestpages:
    PUSH EBX
    PUSH EDX
    PUSH EDI

    MOV EBX, [ESP+4*4]
    MOV EDI, [ESP+5*4]

    kernel BlockAlloc

    MOV EAX, EBX
    TEST EAX, EAX
    POP EDI
    POP EDX
    POP EBX
    RET
