
#include <math.h>

int _PDCLIB_signbitf (float x) {
  unsigned short stw;
  __asm__ ("fxam; fstsw %%ax;": "=a" (stw) : "t" (x));
  return stw & 0x0200;
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( !_PDCLIB_signbitf(1.0) );
    TESTCASE( _PDCLIB_signbitf(-1.0) );
    return TEST_RESULTS;
}

#endif
