/*
    Summary: ceil.c
    *Libc implementation of ceil*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <float.h>
#include <math.h>
#include <stdint.h>

/* Function: ceil
 * gets and returns the integer value of x when rounded up.
 */
double ceil(double x)
{
    double copy = trunc(x);
    if (copy < x) return (copy + 1);
    return(copy);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( ceil(0) == 0 );
    TESTCASE( ceil(1.0) == 1 );
    TESTCASE( ceil(5.1) == 6 );
    TESTCASE( ceil(9.999) == 10 );
    TESTCASE( ceil(-1.0) == -1 );
    TESTCASE( ceil(-5.1) == -5 );
    TESTCASE( ceil(-9.999) == -9 );
    return TEST_RESULTS;
}

#endif
