/*
    Summary: ceilf.c
    *Libc implementation of ceilf*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <float.h>
#include <math.h>
#include <stdint.h>

/* Function: ceilf
 * gets and returns the integer value of x when rounded up.
 */
float ceilf(float x)
{
    float copy = trunc(x);
    if (copy < x) return (copy + 1);
    return(copy);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( ceilf(0) == 0 );
    TESTCASE( ceilf(1.0) == 1 );
    TESTCASE( ceilf(5.1) == 6 );
    TESTCASE( ceilf(9.999) == 10 );
    TESTCASE( ceilf(-1.0) == -1 );
    TESTCASE( ceilf(-5.1) == -5 );
    TESTCASE( ceilf(-9.999) == -9 );
    return TEST_RESULTS;
}

#endif
